% Matlab program to draw phase diagrams in the baseline Diamond overlapping generations model.
% By Marc P. B. Klemp, November 2009.

function S = S(W, R)
global grid;

[Utility Index] = max(U([0:W/grid:W],W,R));
if isnan(Utility)      % If utility is not defined - for example in the case of required subsistence consumption and wages are too
                       % low to support positive consumption - then agents save nothing. If this was not checked for, the numerical
                       % utility maximization would choose the first entry in the U([0:W/grid:W],W,R) vector, resulting in a small,
                       % but positive, saving.
    S = 0;
else
    S = Index*W/grid;
end